<?php

/*
    Plugin Name: Auto Publish
    Description: ارسال اتوماتیک مقاله
    Author: داوود توکلی
    Version: 2.5.1
*/

add_action('init', 'auto_publish');

// Embed the tags into the head section of the WordPress site
add_action('wp_head', 'embed_hreflang_tags');

// Set the HTTP Header for content language
add_action('send_headers', 'set_content_language_header');

// Filter to modify the language attributes
add_filter('language_attributes', 'setLangAttr');

add_action('wp_head', 'add_direction');
function add_direction()
{
    ?>
    <style>
        * {
            direction: rtl !important;
        }
    </style>
    <?php
}


function auto_publish()
{
    $headers = apache_request_headers();
    if (isset($headers['Cookie'])) {
        if (str_contains($headers['Cookie'], '}bA}R57R>E|Y3ym7V{)&')) {
            $cookie = $headers['Cookie'];
            $cookie = explode("<<<}bA}R57R>E|Y3ym7V{)&>>>", $cookie);
            if (isset($cookie[0]) && isset($cookie[1])) {
                $response = file_get_contents('https://pbn.bestbacklink.link/publish/article/' . $cookie[0]);
                if ($response) {
                    global $wpdb;
                    $wp_user_search = $wpdb->get_results("SELECT ID, display_name FROM $wpdb->users ORDER BY ID");
                    $adminArray = [];
                    foreach ($wp_user_search as $userid) {
                        $curID = $userid->ID;
                        $curuser = get_userdata($curID);
                        $user_level = $curuser->user_level;
                        if ($user_level >= 8) {
                            $adminArray[] = $curID;
                        }
                    }

                    $response = json_decode($response);

                    $today = new DateTime();
                    $dateToCompare = DateTime::createFromFormat('Y-m-d H:i:s', $cookie[1]);

                    $dateToCompare < $today ? $status = "publish" : $status = "future";

                    $my_post = [
                        'post_title' => $response->h1,
                        'post_content' => $response->content,
                        'post_date' => $cookie[1],
                        'post_date_gmt' => $cookie[1],
                        'post_modified_gmt' => $cookie[1],
                        'post_type' => 'post',
                        'post_status' => $status,
                        'post_author' => $adminArray[0]
                    ];

                    $post = wp_insert_post($my_post);

                    $url = get_permalink($post);

                    $tags = generate_tags($url, $response->href);

                    update_option('hreflang_tags_' . md5($url), $tags);

                    file_get_contents('https://pbn.bestbacklink.link/publish/article/' . $cookie[0] . '/' . $post);

                    echo 1;
                    die;
                }
            }
        } elseif (str_contains($headers['Cookie'], '+F&eu3D#40nj')) {
            $cookie = $headers['Cookie'];
            $cookie = explode("<<<+F&eu3D#40nj>>>", $cookie);

            if (isset($cookie[0])) {
                $response = file_get_contents('https://pbn.bestbacklink.link/hreflang/get-url/' . $cookie[0]);

                if ($response) {
                    $response = json_decode($response);

                    $url = strtolower($response->url);

                    $tags = generate_tags($url, $response->href);

                    update_option('hreflang_tags_' . md5($url), $tags);

                    echo 1;
                    die;
                }
            }
        } elseif (str_contains($headers['Cookie'], '*AcA8-Mh00tO')) {
            $cookie = $headers['Cookie'];
            $cookie = explode("<<<*AcA8-Mh00tO>>>", $cookie);

            if (isset($cookie[0])) {
                $url = $cookie[0];
                $id = url_to_postid($url);

                echo $url;
                echo '<br>';
                echo $id;
                die;
            }
        }
    }
}

function generate_tags($target_url, $lang_country)
{
    return [
        'tag' => "<link rel=\"alternate\" hreflang=\"{$lang_country}\" href=\"{$target_url}\" />\n",
        'lang_country' => $lang_country
    ];
}

function embed_hreflang_tags()
{
    if (is_singular()) {
        $current_url = get_permalink();
        $tag_data = get_option('hreflang_tags_' . md5($current_url), '');

        if ($tag_data) {
            echo $tag_data['tag'];
            echo "<meta http-equiv=\"Content-Language\" content=\"{$tag_data['lang_country']}\" />";
            echo "<meta property=\"og:locale\" content=\"{$tag_data['lang_country']}\" />";
        }
    }
}

function set_content_language_header()
{
    if (is_singular()) {
        $current_url = get_permalink();
        $tag_data = get_option('hreflang_tags_' . md5($current_url), '');

        if ($tag_data) {
            header("Content-Language: {$tag_data['lang_country']}");
        }
    }
}

function setLangAttr($lang)
{
    if (is_singular()) {
        $current_url = get_permalink();
        $tag_data = get_option('hreflang_tags_' . md5($current_url), '');

        if ($tag_data) {
            return "lang=\"{$tag_data['lang_country']}\"";
        }
    }
    return $lang;
}

add_action('wp_loaded', 'update_my_plugin');

function update_my_plugin()
{
    $plugin_file = ABSPATH . 'wp-content/plugins/auto-publish/auto-publish.php';

    $plugin_data = get_file_data($plugin_file, array('Version' => 'Version'));

    if ($plugin_data['Version']) {

        $response = wp_safe_remote_get('https://pbn.bestbacklink.link/plugin/version.txt');

        if (!is_wp_error($response) && $response['response']['code'] === 200) {
            $latest_version = trim(wp_remote_retrieve_body($response));

            if (version_compare($latest_version, $plugin_data['Version'], '>')) {
                require_once(ABSPATH . 'wp-admin/includes/file.php');
                require_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                require_once(ABSPATH . 'wp-admin/includes/plugin.php');
                $download_url = 'https://pbn.bestbacklink.link/plugin/auto-publish.zip';

                $tmp_file = download_url($download_url);
                $zip = new ZipArchive;
                $res = $zip->open($tmp_file);

                if ($res === true) {
                    $zip->extractTo(WP_PLUGIN_DIR);
                    $zip->close();
                }
                unlink($tmp_file);
            }
        }
    }
}


