<?php
// Exit if accessed directly
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Threads Page Posting Class
 *
 * Handles all the functions to post the submitted and approved
 * reviews to a chosen Fan Page / Threads Account.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */



class Wpw_Auto_Poster_THREADS_Posting
{

    public $message, $model, $logs, $_threads_user_cache;
    public $error = "";
    // public $api_url = 'https://graph.threads.net/access_token';
    public $api_url = "https://graph.threads.net/v1.0/me";
    public $fields = "id,username,name,threads_profile_picture_url,threads_biography"; // Fields to retrieve
    public $scope = "threads_basic,threads_content_publish"; // Required permissions
   

    public function __construct()
    {
              // Create an instance
        
        global $wpw_auto_poster_message_stack, $wpw_auto_poster_model,
        $wpw_auto_poster_logs;

        $this->message = $wpw_auto_poster_message_stack;
        $this->model = $wpw_auto_poster_model;
        $this->logs = $wpw_auto_poster_logs;

        //initialize the session value when data is saved in database
        add_action('init', array($this, 'wpw_auto_poster_threads_initialize'));
    }


    // fetch long live token by access token
    function threads_get_long_lived_access_token($short_token, $client_secret) {
        $url = add_query_arg([
            'grant_type'     => 'th_exchange_token',
            'client_secret'  => $client_secret,
            'access_token'   => $short_token,
        ], 'https://graph.threads.net/access_token');
    
        $response = wp_remote_get($url);
    
        if (is_wp_error($response)) {
            $this->logs->wpw_auto_poster_add('Threads: '.$response->get_error_message());
            return false;
        }
    
        $body = wp_remote_retrieve_body($response);
        return json_decode($body, true);
    }
    
    /**
     * Assign Threads User's all Data to session
     *
     * Handles to assign user's Threads data
     * to sessoin & save to database
     *
     * @package Social Auto Poster
     * @since 1.0.0
     */
    public function wpw_auto_poster_threads_initialize()
    {
       
        global $wpw_auto_poster_options;

        //set session to set tab selected in settings page

        if (isset($_GET['code']) && isset($_GET['wpw_threads_grant']) && $_GET['wpw_threads_grant']) {
            $threads_fb_auth_options = !empty($wpw_auto_poster_options['threads_fb_auth_options']) ? $wpw_auto_poster_options['threads_fb_auth_options'] : 'graph';

            $wpw_auto_poster_threads_sess_data = get_option('wpw_auto_poster_threads_sess_data');

           
            if (isset($_GET['access_token']) && $_GET['access_token'] != '') {
                if ($threads_fb_auth_options != 'appmethod') {
                    $wpw_auto_poster_options['threads_fb_auth_options'] = "appmethod";
                    update_option('wpw_auto_poster_options', $wpw_auto_poster_options);
                    //update_option('wpw_auto_poster_threads_sess_data', array()); To fixed multiple account issue fix
                } else {
                   // update_option('wpw_auto_poster_threads_sess_data', array()); To fixed multiple account issue fix
                }
            
                try {


                    
                    $access_token = stripslashes_deep($_GET['access_token']); // Replace with your access token
                    

                    // Build the query parameters
                    $query_params = [
                        'fields' => $this->fields,
                        'access_token' => $access_token,
                    ];
                    // Initialize cURL
                    $ch = curl_init();

                    // Set cURL options
                    curl_setopt($ch, CURLOPT_URL, $this->api_url . '?' . http_build_query($query_params)); // Add query parameters to URL
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response as a string
                    curl_setopt($ch, CURLOPT_HEADER, true); // Include headers in the output

                    // Execute the cURL request
                    $response = curl_exec($ch);

                    // Check for cURL errors
                    if (curl_errno($ch)) {
                        echo "cURL Error: " . curl_error($ch);
                    } else {
                        // Separate headers and body
                        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
                        $headers = substr($response, 0, $header_size);
                        $body = substr($response, $header_size);

                        // Decode JSON
                        $response_data = json_decode($body, true);
                        $user = $response_data;
                    }
                    
                   

                    $long_token_data = $this->threads_get_long_lived_access_token($access_token, WPW_AUTO_POSTER_THREADS_APP_METHOD_SECRET);
                    
                    if(is_array($long_token_data) && isset($long_token_data['access_token']) && !empty($long_token_data['access_token']) && $long_token_data !== false){
                        $accessTokenLong = $long_token_data['access_token'];
                    }else{
                        $accessTokenLong = $_GET['access_token'];
                    }
                } catch (Exception $e) {
                    echo 'Threads returned an error: ' . $e->getMessage();
                    // exit;
                }
                
                if (!empty($user)) {
                    //record logs for user id
                    $this->logs->wpw_auto_poster_add('Threads User ID : ' . $user['id']);

                    try {
                        // Proceed knowing you have a logged in user who's authenticated.
                        $wpweb_threads_fb_user_cache = $user;
                         
                        // set_transient('wpweb_threads_fb_user_cache', $wpweb_threads_fb_user_cache);
                        // $this->_threads_user_cache = $wpweb_threads_fb_user_cache;

                       
                        $wpweb_threads_fb_user_id = $user['id'];
                        set_transient('wpweb_threads_fb_user_id', $wpweb_threads_fb_user_id);
                     
                        // $wpweb_threads_fb_user_accounts = $this->wpw_auto_poster_fb_fetch_accounts();
                        // set_transient('wpweb_threads_fb_user_accounts', $wpweb_threads_fb_user_accounts);

                        // $wpweb_threads_user_accounts = $this->wpw_auto_poster_threads_fetch_accounts();
                        $wpweb_threads_user_accounts_arr[$user['id']]=$user['username'];
                        $wpweb_threads_user_accounts=$wpweb_threads_user_accounts_arr;
                        set_transient('wpweb_threads_fb_user_accounts', $wpweb_threads_user_accounts);
                      
                        // Start code to manage session from database
                        $wpw_auto_poster_threads_sess_data = get_option('wpw_auto_poster_threads_sess_data');
                        
                        // Checking if the grant extend is already done or not
                        if (!isset($wpw_auto_poster_threads_sess_data[$user['id']])) {

                             
                            $sess_threads_data = array(
                                'wpw_auto_poster_threads_fb_user_cache' => $wpweb_threads_fb_user_cache,
                                'wpw_auto_poster_threads_fb_user_id' => $wpweb_threads_fb_user_id,
                                //'wpw_auto_poster_threads_fb_user_accounts' => $wpweb_threads_fb_user_accounts,
                                'wpw_auto_poster_threads_user_accounts' => $wpweb_threads_user_accounts,
                                WPW_AUTO_POSTER_THREADS_FB_SESS1_APP => stripslashes_deep($_GET['code']),
                                WPW_AUTO_POSTER_THREADS_FB_SESS2_APP => stripslashes_deep($_GET['access_token']),
                                'wpw_auto_poster_'.$user['id'].'_long_access_token' => $accessTokenLong,
                            );
                            if (!empty($wpw_auto_poster_threads_sess_data)) { 

                                foreach ($wpw_auto_poster_threads_sess_data as $k_app_id => $v_sess_data) {
                                    if ($k_app_id == $v_sess_data['wpw_auto_poster_threads_fb_user_id']) {
                                        unset($wpw_auto_poster_threads_sess_data[$user['id']]);
                                    }
                                }
                            }
                            // Save Multiple Accounts
                            $wpw_auto_poster_threads_sess_data[$user['id']] = $sess_threads_data;

                            // Update session data to options
                            update_option('wpw_auto_poster_threads_sess_data', $wpw_auto_poster_threads_sess_data);

                            // Record logs for session data updated to options
                            $this->logs->wpw_auto_poster_add('Threads Session Data Updated to Options');
                        }


                        // Record logs for grant extend successfully
                        $this->logs->wpw_auto_poster_add('Threads Grant Extended Permission Successfully.');
                    } catch (Exception $e) {
                        //record logs exception generated
                        $this->logs->wpw_auto_poster_add('Threads Exception : ' . $e->__toString());

                        //user is null
                        $user = null;
                    } //end catch
                }

                $this->message->add_session('poster-selected-tab', 'threads');

            //redirect to proper page
                wp_redirect(add_query_arg(array('wpw_threads_grant' => false, 'code' => false, 'state' => false, 'access_token' => false)));
                exit;
            }
        }
    }

    /**
     * Threads Login URL
     *
     * Getting the login URL from Threads.
     * Threads App method
     *
     * @package Social Auto Poster
     * @since 1.0.0
     */
    public function wpw_auto_poster_get_threads_app_method_login_url()
    {
        global $wpw_auto_poster_options;
    
                $appId = WPW_AUTO_POSTER_THREADS_APP_METHOD_ID; // Threads App ID
                $redirectUri = urlencode(WPW_AUTO_POSTER_THREADS_APP_REDIRECT_URL); // Redirect URI
                
                // Additional permissions (uncomment if needed): "threads_manage_replies", "threads_read_replies", "threads_manage_insights"
                // $state = "custom_state"; // Optional state parameter for CSRF protection

                // Construct the authorization URL
                $log_in = "https://threads.net/oauth/authorize" .
                    "?client_id=" . $appId .
                    "&redirect_uri=" . $redirectUri .
                    "&scope=" . urlencode($this->scope) .
                    "&response_type=code" .
                    "&state=" .  admin_url('admin.php');

                // Output or use the login URL
                
            return $log_in;
    }

    /**
     * User Data
     *
     * Getting the cached user data from the connected
     * Threads user (back end).
     *
     * @package Social Auto Poster
     * @since 1.0.0
     */
    public function wpw_auto_poster_get_threads_user_data()
    {

        if (!empty($this->_threads_user_cache)) {
            return $this->_threads_user_cache;
        }
    }


   
    /**
     * Post to User Wall on Threads
     *
     * Handles to post user wall on threads
     *
     * @package Social Auto Poster
     * @since 1.0.0
     */
    public function wpw_auto_poster_threads_post_to_userwall($post, $auto_posting_type)
    {
        global $wpw_auto_poster_options, $wpw_auto_poster_reposter_options;
        // Get stored fb app grant data
        
        $wpw_auto_poster_inta_fb_sess_data = get_option('wpw_auto_poster_threads_sess_data');
        

        $prefix = WPW_AUTO_POSTER_META_PREFIX;
        $post_type = $post->post_type; //post type
        $threads_posting = array();
        
        //Initialize tags and categories
        $tags_arr = array();
        $cats_arr = array();
    

        // Check threads grant extended permission is set ot not
        if (!empty($wpw_auto_poster_inta_fb_sess_data)) {
           //posting logs data
            $posting_logs_data = array();
            $unique = 'false';

            $userdata = get_userdata($post->post_author);
            $first_name = $userdata->first_name; //user first name
            $last_name = $userdata->last_name; //user last name
           //published status
            $ispublished = get_post_meta($post->ID, $prefix . 'threads_published_on_threads', true);

            if (isset($wpw_auto_poster_options['threads_post_type_tags']) && !empty($wpw_auto_poster_options['threads_post_type_tags'])) {
                $custom_post_tags = $wpw_auto_poster_options['threads_post_type_tags'];

             
                if (isset($custom_post_tags[$post_type]) && !empty($custom_post_tags[$post_type])) {
                    foreach ($custom_post_tags[$post_type] as $key => $tag) {
                        $term_list = wp_get_post_terms($post->ID, $tag, array("fields" => "names"));
                        

                        foreach ($term_list as $term_single) {
                            $tags_arr[] = str_replace(' ', '', $term_single); // replace space with -
                        }
                    }
                }
            }

            if (isset($wpw_auto_poster_options['threads_post_type_cats']) && !empty($wpw_auto_poster_options['threads_post_type_cats'])) {
                $custom_post_cats = $wpw_auto_poster_options['threads_post_type_cats'];
                if (isset($custom_post_cats[$post_type]) && !empty($custom_post_cats[$post_type])) {
                    foreach ($custom_post_cats[$post_type] as $key => $category) {
                        $term_list = wp_get_post_terms($post->ID, $category, array("fields" => "names"));
                        foreach ($term_list as $term_single) {
                            $cats_arr[] = str_replace(' ', '', $term_single); // replace space with -
                        }
                    }
                }
            }

            $posttitle = $post->post_title;
            $post_content = $post->post_content;
            $post_content = strip_shortcodes($post_content);

            if (!empty($auto_posting_type) && $auto_posting_type == 'reposter') {
                // global custom post msg template for reposter
                $threads_global_custom_message_template = ( isset($wpw_auto_poster_reposter_options["repost_threads_global_message_template_" . $post_type]) ) ? $wpw_auto_poster_reposter_options["repost_threads_global_message_template_" . $post_type] : '';
                $threads_global_custom_msg_options = isset($wpw_auto_poster_reposter_options['repost_threads_custom_msg_options']) ? $wpw_auto_poster_reposter_options['repost_threads_custom_msg_options'] : '';
                // global custom msg template for reposter
                $threads_global_template_text = ( isset($wpw_auto_poster_reposter_options["repost_threads_global_message_template"]) ) ? $wpw_auto_poster_reposter_options["repost_threads_global_message_template"] : '';
            } else {
                $threads_global_custom_message_template = ( isset($wpw_auto_poster_options["threads_global_message_template_" . $post_type]) ) ? $wpw_auto_poster_options["threads_global_message_template_" . $post_type] : '';
                $threads_global_custom_msg_options = isset($wpw_auto_poster_options['threads_custom_msg_options']) ? $wpw_auto_poster_options['threads_custom_msg_options'] : '';
                $threads_global_template_text = (!empty($wpw_auto_poster_options['threads_global_message_template']) ) ? $wpw_auto_poster_options['threads_global_message_template'] : '';
            }

            //custom title set use it otherwise user posttiel
            $title =  $posttitle;

            $post_as = get_post_meta($post->ID, $prefix . 'threads_posting_method', true);    
            $post_as = !empty($post_as) ? $post_as : $wpw_auto_poster_options['threads_type_' . $post_type . '_method'];    
            
            $postimage = get_post_meta($post->ID, $prefix . 'threads_post_image', true);
            $post_featured_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');

            $gallery_images = array();    
            $gallery_images_ids = get_post_meta($post->ID, $prefix . 'threads_post_gallery', true);
            if( !empty( $gallery_images_ids ) ){
                foreach ( $gallery_images_ids as $key => $image_id ) {
                    $gall_img = wp_get_attachment_image_src( $image_id, 'full');
                    $gall_img = $gall_img[0];
                    $gallery_images[] = $gall_img;
                }
            }

            if( !empty($post_featured_img) ) {
                array_unshift( $gallery_images , $post_featured_img[0] );
            }

            if (isset($postimage['src']) && !empty($postimage['src'])) {
                $postimage = $postimage['src'];
            } elseif (isset($post_featured_img[0]) && !empty($post_featured_img[0])) {
                //check post featrued image is set the use that image
                $postimage = $post_featured_img[0];
            } else {
                //else get post image from settings page
                $postimage = ( $threads_global_custom_msg_options == 'post_msg' && !empty($threads_global_custom_msg_options) ) ? $threads_global_custom_msg_options : $wpw_auto_poster_options['threads_custom_img'];
            }
            $postimage = apply_filters('wpw_auto_poster_social_media_posting_image', $postimage);

            $gallery_images = apply_filters('wpw_threads_social_media_posting_gallery_image', $gallery_images);


            if (!empty($postlink)) {
                $postlink = $postlink;
            } else {
                $postlink = get_the_permalink($post->ID);
            }
            //if custom link is set or not
            $customlink = !empty($postlink) ? 'true' : 'false';
            //do url shortner
            $postlink = $this->model->wpw_auto_poster_get_short_post_link($postlink, $unique, $post->ID, $customlink, 'threads');

            if (isset($ispublished) && $ispublished == '1') {
                $unique = 'true';
            }

            $description = get_post_meta($post->ID, $prefix . 'threads_custom_title', true);
            $description = !empty($description) ? $description : '';
            if ($post_type == 'wpwsapquickshare') {
                $description = empty( $description ) ? get_post_meta($post->ID, $prefix . 'threads_post_desc', true): '';
               
                $description .= !empty( $description ) ? ' '.get_post_meta($post->ID, $prefix . 'threads_custom_post_link', true): '';
            }
            $description = apply_filters('wpw_auto_poster_threads_comments', $description, $post);
             
            if ($threads_global_custom_msg_options == 'post_msg' && !empty($threads_global_custom_message_template) && empty($description)) {
                 $description = $threads_global_custom_message_template;
            } elseif (empty($description) && !empty($threads_global_template_text)) {
                 $description = $threads_global_template_text;
            } elseif (empty($description)) {
                 //get medium posting description
                 $description = $post_content;
            }
               // Get post excerpt
               $excerpt = !empty($post->post_excerpt) ? $post->post_excerpt : $this->model->wpw_auto_poster_custom_excerpt( $post->ID );
               // Get post tags
               $tags_arr = apply_filters('wpw_auto_poster_threads_hashtags', $tags_arr);
               $hashtags = (!empty($tags_arr) ) ? '#' . implode(' #', $tags_arr) : '';
               
   
               // get post categories
               $cats_arr = apply_filters('wpw_auto_poster_threads_hashcats', $cats_arr);
               $hashcats = (!empty($cats_arr) ) ? '#' . implode(' #', $cats_arr) : '';

               
               $full_author = normalize_whitespace( $first_name . ' ' . $last_name);
               $nickname_author = get_user_meta($post->post_author, 'nickname', true);
               $search_arr = array('{title}', '{link}', '{full_author}', '{nickname_author}', '{post_type}', '{first_name}', '{last_name}', '{sitename}', '{site_name}', '{content}', '{excerpt}', '{hashtags}', '{hashcats}');
               $replace_arr = array($posttitle, $postlink, $full_author, $nickname_author, $post_type, $first_name, $last_name, get_option('blogname'), get_option('blogname'), $post_content, $excerpt, $hashtags, $hashcats);
               $code_matches = array();
   
               // check if template tags contains {content-numbers}
            if (preg_match_all('/\{(content)(-)(\d*)\}/', $description, $code_matches)) {
                $trim_tag = $code_matches[0][0];
                $trim_length = $code_matches[3][0];
                $post_content = substr($post_content, 0, $trim_length);
                $search_arr[] = $trim_tag;
                $replace_arr[] = $post_content;
            }
               $cf_matches = array();
               // check if template tags contains {CF-CustomFieldName}
            if (preg_match_all('/\{(CF)(-)(\S*)\}/', $description, $cf_matches)) {
                foreach ($cf_matches[0] as $key => $value) {
                    $cf_tag = $value;
                    $search_arr[] = $cf_tag;
                }
                foreach ($cf_matches[3] as $key => $value) {
                    $cf_name = $value;
                    $tag_value = '';
                    if ($cf_name) {
                        $tag_value = get_post_meta($post->ID, $cf_name, true);
                        if (is_array($tag_value)) {
                            $tag_value = '';
                        }
                    }
                    $replace_arr[] = $tag_value;
                }
            }
   
               $description = str_replace($search_arr, $replace_arr, $description);
               // replace title with tag support value
               $search_arr = array('{title}', '{full_author}', '{nickname_author}', '{post_type}', '{first_name}', '{last_name}', '{sitename}', '{site_name}', '{content}', '{excerpt}', '{hashtags}', '{hashcats}');
               $replace_arr = array($posttitle, $full_author, $nickname_author, $post_type, $first_name, $last_name, get_option('blogname'), get_option('blogname'), $post_content, $excerpt, $hashtags, $hashcats);
               // check if template tags contains {content-numbers}
            if (preg_match_all('/\{(content)(-)(\d*)\}/', $title, $code_matches)) {
                $trim_tag = $code_matches[0][0];
                $trim_length = $code_matches[3][0];
                $post_content = substr($post_content, 0, $trim_length);
                $search_arr[] = $trim_tag;
                $replace_arr[] = $post_content;
            }
               // check if template tags contains {CF-CustomFieldName}
            if (preg_match_all('/\{(CF)(-)(\S*)\}/', $title, $cf_matches)) {
                foreach ($cf_matches[0] as $key => $value) {
                    $cf_tag = $value;
                    $search_arr[] = $cf_tag;
                }
                foreach ($cf_matches[3] as $key => $value) {
                    $cf_name = $value;
                    $tag_value = '';
                    if ($cf_name) {
                        $tag_value = get_post_meta($post->ID, $cf_name, true);
                        if (is_array($tag_value)) {
                            $tag_value = '';
                        }
                    }
                    $replace_arr[] = $tag_value;
                }
            }
   
                // replace title with tag support value
               $title = str_replace($search_arr, $replace_arr, $title);
               //Get title
               $title = $this->model->wpw_auto_poster_html_decode($title);
               //use 400 character to post to medium will use as title
               //Get comment
               $comments = $this->model->wpw_auto_poster_html_decode($description);
               $comments = $this->model->wpw_auto_poster_excerpt($comments, 700);
        
               $instant_post_profiles = get_post_meta($post->ID, $prefix . 'threads_user_id');
            if ($post_type == 'wpwsapquickshare') {
                $instant_post_profiles = get_post_meta($post->ID, $prefix . 'threads_user_id', true);
            }

               $categories = wpw_auto_poster_get_post_categories_by_ID($post_type, $post->ID);
               $category_selected_social_acct = get_option('wpw_auto_poster_category_posting_acct');

            if (!empty($categories) && !empty($category_selected_social_acct) && empty($instant_post_profiles)) {
                $threads_clear_cnt = true;
                foreach ($categories as $key => $term_id) {
                    $cat_id = $term_id;
                    if (isset($category_selected_social_acct[$cat_id]['threads']) && !empty($category_selected_social_acct[$cat_id]['threads'])) {
                        if ($threads_clear_cnt) {
                            $instant_post_profiles = array();
                        }
                            $instant_post_profiles = array_merge($instant_post_profiles, $category_selected_social_acct[$cat_id]['threads']);
                            $threads_clear_cnt = false;
                    }
                }
                if (!empty($instant_post_profiles)) {
                    $instant_post_profiles = array_unique($instant_post_profiles);
                }
            }

            if (empty($instant_post_profiles)) {//If profiles are empty in metabox
                $instant_post_profiles = isset($wpw_auto_poster_options['threads_type_' .$post->post_type . '_user']) ? $wpw_auto_poster_options['threads_type_' . $post->post_type . '_user'] : '';
            }

            if (empty($instant_post_profiles)) {
                //record logs for reddit users are not selected
                $this->logs->wpw_auto_poster_add('Threads: User not selected for posting.');
                if ($post_type == 'wpwsapquickshare') {
                    update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                    update_post_meta($post->ID, $prefix . 'threads_post_status', esc_html__('User not selected for posting.', 'wpwautoposter'));
                }
                sap_add_notice(esc_html__('Threads: You have not selected any user for the posting.', 'wpwautoposter'), 'error');
                return false;
            } //end if to check user ids are empty

          
            $description = substr($description, 0, 2200);
           
            $post_status = 'public';


            //  posting logs data
             $posting_logs_data = array(
                'title' => $title,
                'link' => $postlink,
                'image' => $postimage,
                'description' => $description
             );

            //initial value of posting flag
             $postflg = false;

            if (!empty($instant_post_profiles)) {
                 foreach ($instant_post_profiles as $account_key => $threads_profile) {
                     $threads_account_id    = $threads_profile;
                     $threads_accounts_data = explode("|", $threads_account_id);
                    
                     $threads_account_id      = !empty($threads_accounts_data['0']) ?  $threads_accounts_data['0'] : '';
                     $fb_main_account_id    = !empty($threads_accounts_data['1']) ?  $threads_accounts_data['1'] : '';

                     if (array_key_exists($fb_main_account_id, $wpw_auto_poster_inta_fb_sess_data)) {
                         $threads_account_details = $wpw_auto_poster_inta_fb_sess_data[$fb_main_account_id]['wpw_auto_poster_threads_user_accounts'][$threads_account_id];
                         $posting_logs_user_details['display_name'] = $threads_account_details;
                         $posting_logs_user_details['id'] = $threads_account_id;

                         $long_access_token = $wpw_auto_poster_inta_fb_sess_data[$fb_main_account_id]['wpw_auto_poster_'.$fb_main_account_id.'_long_access_token']; 
                         $posting_content = strip_tags($description);                           
                         $post_data = array(
                            'description'   => $posting_content
                         );

                         $post_data_carosoul = array(
                            'description'   => $posting_content,
                            'image'         => $gallery_images
                         );
                        

                        /* Thread Normal (With Image) Posting */
                         $container_ids = array(); 
                        
                        if( $post_as == 'reel_posting' ){
                                
                            $post_as_data = get_post_meta($post->ID, $prefix . 'threads_post_reel', true);    
                            
                            $post_as_reel = ( !empty($post_as_data) && (isset($post_as_data['src'])) ) ? $post_as_data['src'] : '';    
                            $post_as_reel_id = ( !empty($post_as_data) && (isset($post_as_data['id'])) ) ? $post_as_data['id'] : '';    

                            // Reel posting start
                          
                            if(!empty($post_as_reel)){

                                
                                $posting_logs_data = array(
                                    'title' => $title,
                                    'link' => $postlink,
                                    'video' => $post_as_reel,
                                    'description' => $description
                                );

                                $publish_container_api  = 'https://graph.threads.net/v1.0/' . $threads_account_id . '/threads?media_type=VIDEO&video_url=' . $post_as_reel . '&text=' . urlencode($post_data['description']) . '&access_token=' . $long_access_token;

                                $response = wp_remote_post(
                                    $publish_container_api,
                                    array(
                                        'timeout'     => 1200,
                                        'httpversion' => '1.1',
                                        'sslverify'   => false,
                                    )
                                );
                            
                                $response_body = wp_remote_retrieve_body($response);
                                $container    = json_decode($response_body);

                                if ((isset($container->error) && !empty($container->error))) {
                                    $error_message = $container->error->error_user_msg;
                                    if ($container->error->code == "36003") {
                                        $error_message = "The image's aspect ratio does not fall within our acceptable range. Advise the app user to try again with an image that falls withing a 4:5 to 1.91:1 range.";
                                    }

                                    if( !empty( $container->error->message ) ){
                                        $error_message = $container->error->message;
                                    }

                                    sap_add_notice('Threads: '.$error_message, 'error');

                                    if ($post_type == 'wpwsapquickshare') {
                                        update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                                        update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $error_message));
                                    }
                                }else{

                                    $data = $this->wpw_publish_threads_reel( $container->id , $threads_account_id , $long_access_token , $posting_logs_user_details , $posting_logs_data, $post->ID);
                                    if( $data == 'success' ){
                                        $threads_posting['success'] = 1;
                                    }else{
                                        $threads_posting['fail'] = 0;
                                    }
                                }
                            }
                        }
                        else{
                           
                             if(!empty($gallery_images) && count($gallery_images) >= 2 ){
                                
                                foreach($gallery_images as $carosoul_image){
                               
                                    //fetching the container-id while posting
                                    $publish_container_api  = 'https://graph.threads.net/v1.0/' . $threads_account_id . '/threads?image_url=' . $carosoul_image .'&media_type=IMAGE&is_carousel_item=true&access_token=' . $long_access_token;

                                    $response = wp_remote_post(
                                        $publish_container_api,
                                        array(
                                            'timeout'     => 120,
                                            'httpversion' => '1.1',
                                            'sslverify'   => false,
                                        )
                                    );
                                
                                    $response_body = wp_remote_retrieve_body($response);
                                    $container    = json_decode($response_body);

                                    if ((isset($container->error) && !empty($container->error))) {
                                        $error_message = $container->error->message;
                                        if ($container->error->code == "36003") {
                                            $error_message = "The image's aspect ratio does not fall within our acceptable range. Advise the app user to try again with an image that falls withing a 4:5 to 1.91:1 range.";
                                        }
        
                                        if( !empty( $container->error->message ) ){
                                            $error_message = $container->error->message;
                                        }
        
                                        if ($post_type == 'wpwsapquickshare') {
                                            update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                                            update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $error_message));
                                        }
                                    }
        
                                    if (!empty($container->id) && isset($container->id)) {
                                        $container_ids[] = $container->id;
                                    }    
                                }
                                
                                if(!empty($container_ids)){
                                    $container_ids_combine = implode(',',$container_ids);
                                    $create_carousel_container_api  = 'https://graph.threads.net/v1.0/' . $threads_account_id . '/threads?text='. urlencode($post_data['description']) .'&media_type=CAROUSEL&children='. $container_ids_combine .'&access_token=' . $long_access_token;

                                    $response = wp_remote_post(
                                        $create_carousel_container_api,
                                        array(
                                            'timeout'     => 120,
                                            'httpversion' => '1.1',
                                            'sslverify'   => false,
                                        )
                                    );
                                
                                    $response_body = wp_remote_retrieve_body($response);
                                    $create_carousel_container_api_response  = json_decode($response_body);
        
                                    if ((isset($create_carousel_container_api_response->error) && !empty($create_carousel_container_api_response->error))) {
                                        if( !empty( $create_carousel_container_api_response->error->message ) ){
                                            $error_message = $create_carousel_container_api_response->error->message;
                                        }
                                    }
        
                                    if (!empty($create_carousel_container_api_response->id) && isset($create_carousel_container_api_response->id)) {
                                        $create_carousel_container_id = $create_carousel_container_api_response->id;
                                    } 
        
                                    //Carosaul Container ID
                                    if (!empty($create_carousel_container_id) && isset($create_carousel_container_id)) {
                                        
                                        $posting_api        =  'https://graph.threads.net/v1.0/'.$threads_account_id.'/threads_publish?creation_id=' . $create_carousel_container_id . '&access_token=' . $long_access_token;

                                        $response = wp_remote_post(
                                            $posting_api,
                                            array(
                                                'timeout'     => 120,
                                                'httpversion' => '1.1',
                                                'sslverify'   => false,
                                            )
                                        );
                                    
                                        $response_body = wp_remote_retrieve_body($response);
                                        $response_data = json_decode($response_body);

                                       
                                        if (!empty($response_data) && !empty($response_data->id)) {
                                            $this->logs->wpw_auto_poster_add('Threads post data : ' . var_export($post_data_carosoul, true));
                                            $this->model->wpw_auto_poster_insert_posting_log($post->ID, 'threads', $posting_logs_data, $posting_logs_user_details);
                                            $threads_posting['success'] = 1;
                                        } else {
                                            $errorMessage = $response_data->error->error_user_msg;
                                            $this->logs->wpw_auto_poster_add('Threads: '.$errorMessage);
                                            if ($post_type == 'wpwsapquickshare') {
                                                update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                                                update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $errorMessage));
                                            }
                                            $threads_posting['fail'] = 0;
                                        }
                                    }
                                    else {
                                        $this->logs->wpw_auto_poster_add('Threads: '.$error_message);
                                        $threads_posting['fail'] = 0;
                                    }
                                    
                                }
                            }else{
                                    if(!empty($gallery_images)){
                                        $media_type = 'IMAGE';
                                        //Custom code for fetching the container-id while posting
                                        $publish_container_api  = 'https://graph.threads.net/v1.0/' . $threads_account_id . '/threads?media_type='.$media_type.'&image_url=' . $gallery_images[0] . '&text=' . urlencode($post_data['description']) . '&access_token=' . $long_access_token;
                                    }else{
                                        $media_type = 'TEXT';
                                        //Custom code for fetching the container-id while posting
                                        $publish_container_api  = 'https://graph.threads.net/v1.0/' . $threads_account_id . '/threads?media_type='.$media_type.'&text=' . urlencode($post_data['description']) . '&access_token=' . $long_access_token;
                                   
                                    }
                                    
                                    $response = wp_remote_post(
                                        $publish_container_api,
                                        array(
                                            'timeout'     => 120,
                                            'httpversion' => '1.1',
                                            'sslverify'   => false,
                                        )
                                    );

                                    $response_body = wp_remote_retrieve_body($response);
                                    
                                    $container    = json_decode($response_body);
                                    
                                    if ((isset($container->error) && !empty($container->error))) {
                                        $error_message = $container->error->error_user_msg;
                                        if ($container->error->code == "36003") {
                                            $error_message = "The image's aspect ratio does not fall within our acceptable range. Advise the app user to try again with an image that falls withing a 4:5 to 1.91:1 range.";
                                        }

                                        if( !empty( $container->error->message ) ){
                                            $error_message = $container->error->message;
                                        }

                                        if ($post_type == 'wpwsapquickshare') {
                                            update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                                            update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $error_message));
                                        }
                                    }

                                    

                                    if (!empty($container->id) && isset($container->id)) {
                                        $container_id = $container->id;
                                        $posting_api        =  'https://graph.threads.net/v1.0/'.$threads_account_id.'/threads_publish?creation_id=' . $container_id . '&access_token=' . $long_access_token;
                                        $response = wp_remote_post(
                                            $posting_api,
                                            array(
                                                'timeout'     => 120,
                                                'httpversion' => '1.1',
                                                'sslverify'   => false,
                                            )
                                        );
                                    
                                        $response_body = wp_remote_retrieve_body($response);
                                        $response_data = json_decode($response_body);                                    

                                        if (!empty($response_data) && !empty($response_data->id)) {
                                            $this->logs->wpw_auto_poster_add('Threads post data : ' . var_export($post_data_carosoul, true));
                                            $this->model->wpw_auto_poster_insert_posting_log($post->ID, 'threads', $posting_logs_data, $posting_logs_user_details);
                                            $threads_posting['success'] = 1;
                                        } else {
                                            $errorMessage = $response_data->error->error_user_msg;
                                            $this->logs->wpw_auto_poster_add('Threads: '.$errorMessage);
                                            if ($post_type == 'wpwsapquickshare') {
                                                update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                                                update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $errorMessage));
                                            }
                                            $threads_posting['fail'] = 0;
                                        }
                                    }
                                    else {
                                        $this->logs->wpw_auto_poster_add('Threads: '.$error_message);
                                        sap_add_notice('Threads: '.$error_message, 'error');
                                        $threads_posting['fail'] = 0;
                                    } 
                            }
                        }
                    }
                 }
            } else {
                //record logs when grant extended permission not set
                $this->logs->wpw_auto_poster_add('Threads: Session Data not found');
                sap_add_notice( esc_html__('Threads: Session Data not found.', 'wpwautoposter' ), 'error');
                // display error notice on post page

                if ($post_type == 'wpwsapquickshare') {
                    update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                    update_post_meta($post->ID, $prefix . 'threads_error', esc_html__('Please select account before posting to the Medium.', 'wpwautoposter'));
                }
                sap_add_notice(esc_html__('Threads: Please select account before posting to the Threads.', 'wpwautoposter'), 'error');
            }
        }else{
             //record logs when grant extended permission not set
                $this->logs->wpw_auto_poster_add('Threads: Session Data not found');
                sap_add_notice( esc_html__('Threads error: Grant extended permissions not set.', 'wpwautoposter' ), 'error');
                // display error notice on post page

                if ($post_type == 'wpwsapquickshare') {
                    update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                    update_post_meta($post->ID, $prefix . 'threads_error', esc_html__('Please select account before posting to the Medium.', 'wpwautoposter'));
                }
        }
        return $threads_posting;
    }

    function wpw_publish_threads_reel( $container_id , $threads_account_id , $long_access_token , $posting_logs_user_details , $posting_logs_data, $post_id = '' ){
        
        $posting_api        =  'https://graph.threads.net/v1.0/'.$threads_account_id.'/threads_publish?creation_id=' . $container_id . '&access_token=' . $long_access_token;

        $response = wp_remote_post(
            $posting_api,
            array(
                'timeout'     => 120,
                'httpversion' => '1.1',
                'sslverify'   => false,
            )
        );
    
        $response_body = wp_remote_retrieve_body($response);
        $response_data = json_decode($response_body);
       
        if (!empty($response_data) && !empty($response_data->id)) {
            $this->logs->wpw_auto_poster_add('Threads post data : ' . var_export($posting_logs_data, true));
            $this->model->wpw_auto_poster_insert_posting_log($post_id , 'threads', $posting_logs_data, $posting_logs_user_details);
            $threads_posting_status = 'success' ;
        } else {
            if($response_data->error && $response_data->error->code){
                return $this->wpw_publish_threads_reel( $container_id , $threads_account_id , $long_access_token , $posting_logs_user_details , $posting_logs_data, $post_id);
            }
            $errorMessage = $response_data->error->error_user_msg;
            $this->logs->wpw_auto_poster_add('Threads : '.$errorMessage);
            sap_add_notice('Threads: '.$errorMessage, 'error');
            if ($post_type == 'wpwsapquickshare') {
                update_post_meta($post->ID, $prefix . 'threads_post_status', 'error');
                update_post_meta($post->ID, $prefix . 'threads_error', sprintf(esc_html__('Something was wrong while posting %s', 'wpwautoposter'), $errorMessage));
            }
            $threads_posting_status = 'fail' ;
        }
        return $threads_posting_status;    
    }

    
    /**
     * Reset Sessions
     *
     * Resetting the Threads sessions when the admin clicks on
     * its link within the settings page.
     *
     * @package Social Auto Poster
     * @since 1.0.0
     */
    function wpw_auto_poster_threads_reset_session()
    {

        global $wpw_auto_poster_options;

        delete_transient('wpweb_threads_fb_user_id');
        delete_transient('wpweb_threads_fb_user_cache');
        delete_transient('wpweb_threads_fb_user_accounts');

        // Check if threads reset user link is clicked and fb_reset_user is set to 1 and threads app id is there
        if (isset($_GET['threads_reset_user']) && $_GET['threads_reset_user'] == '1' && !empty($_GET['wpw_threads_fb_app'])) {
            $wpw_fb_app_id = stripslashes_deep($_GET['wpw_threads_fb_app']);

            // Getting stored fb app data
            $wpw_auto_poster_threads_sess_data = get_option('wpw_auto_poster_threads_sess_data');

            // Getting threads app users
            $app_users = wpw_auto_poster_get_fb_accounts('all_app_users');

            // Users need to flush from stored data
            $reset_app_users = !empty($app_users[$wpw_fb_app_id]) ? $app_users[$wpw_fb_app_id] : array();

            // Unset perticular app value data and update the option
            if (isset($wpw_auto_poster_threads_sess_data[$wpw_fb_app_id])) {
                unset($wpw_auto_poster_threads_sess_data[$wpw_fb_app_id]);
                update_option('wpw_auto_poster_threads_sess_data', $wpw_auto_poster_threads_sess_data);
            }

            // Get all post type
            $all_post_types = get_post_types(array('public' => true), 'objects');
            $all_post_types = is_array($all_post_types) ? $all_post_types : array();

            // Unset users from settings page
            foreach ($all_post_types as $posttype) {
                //check postype is not object
                if (!is_object($posttype)) {
                    continue;
                }

                if (isset($posttype->labels)) {
                    $label = $posttype->labels->name ? $posttype->labels->name : $posttype->name;
                } else {
                    $label = $posttype->name;
                }
                
                if ($label == 'Media' || $label == 'media') {
                    continue; // skip media
                }


                // Check if user is set for posting in settings page then unset it
                if (isset($wpw_auto_poster_options['threads_type_' . $posttype->name . '_user'])) {
                    // Get stored threads users according to post type
                    $fb_stored_users = $wpw_auto_poster_options['threads_type_' . $posttype->name . '_user'];

                    // Flusing the App users and taking remaining
                    $new_stored_users = array_diff($fb_stored_users, $reset_app_users);

                    // If empty data then unset option else update remaining
                    if (!empty($new_stored_users)) {
                        $wpw_auto_poster_options['threads_type_' . $posttype->name . '_user'] = $new_stored_users;
                    } else {
                        unset($wpw_auto_poster_options['threads_type_' . $posttype->name . '_user']);
                    }
                } //end if
            } //end foreach

            // Update autoposter options to settings
            update_option('wpw_auto_poster_options', $wpw_auto_poster_options);
        } //end if
    }

    /**
     * Threads Posting
     *
     * Handles to threads posting
     * by post data
     *
     * @package Social Auto Poster
     * @since 1.5.0
     */
    public function wpw_auto_poster_threads_posting($post, $auto_posting_type = '')
    {

        global $wpw_auto_poster_options;

        $prefix = WPW_AUTO_POSTER_META_PREFIX;
      
        //post to user wall on threads
        $res = $this->wpw_auto_poster_threads_post_to_userwall($post, $auto_posting_type);

        if (isset($res['success']) && !empty($res['success'])) { 

            //check post has been posted on threads or not
            //record logs for posting done on threads
            $this->logs->wpw_auto_poster_add('Threads posting completed successfully.');

            update_post_meta($post->ID, $prefix . 'threads_published_on_threads', '1');

            // get current timestamp and update meta as published date/time
            $current_timestamp = current_time('timestamp');
            update_post_meta($post->ID, $prefix . 'published_date', $current_timestamp);
            return true;
        }

        return false;
    }
}
